/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.text2speech;

import com.mojang.text2speech.Narrator;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

public class NarratorLinux
implements Narrator {
    private final AtomicInteger executionBatch = new AtomicInteger();
    private final Pointer voiceCmuUsKal16;
    private final ExecutorService executor;

    public NarratorLinux() throws Narrator.InitializeException {
        FliteLibrary.loadNative();
        FliteLibrary.CmuUsKal16.loadNative();
        int rc = FliteLibrary.flite_init();
        if (rc != 0) {
            throw new Narrator.InitializeException("flite returned code " + rc);
        }
        this.voiceCmuUsKal16 = FliteLibrary.CmuUsKal16.register_cmu_us_kal16(null);
        if (this.voiceCmuUsKal16 == Pointer.NULL) {
            throw new Narrator.InitializeException("flite_cmu_us_kal16 failed to register");
        }
        this.executor = Executors.newSingleThreadExecutor();
    }

    @Override
    public void say(String msg, boolean interrupt) {
        if (interrupt) {
            this.clear();
        }
        int thisBatch = this.executionBatch.get();
        Arrays.stream(msg.split("[,.:;/\"()\\[\\]{}!?\\\\]+")).filter(x -> !x.isBlank()).forEach(unit -> this.executor.submit(() -> {
            if (thisBatch < this.executionBatch.get()) {
                return;
            }
            FliteLibrary.flite_text_to_speech(unit, this.voiceCmuUsKal16, "play");
        }));
    }

    @Override
    public void clear() {
        this.executionBatch.incrementAndGet();
    }

    @Override
    public void destroy() {
        this.executor.shutdownNow();
    }

    private static class FliteLibrary {
        private static final int SUCCESS = 0;
        private static final String NATIVE_LIBRARY_NAME = "flite";

        private FliteLibrary() {
        }

        public static void loadNative() throws Narrator.InitializeException {
            try {
                Native.register(FliteLibrary.class, (NativeLibrary)NativeLibrary.getInstance((String)NATIVE_LIBRARY_NAME));
            }
            catch (Throwable e) {
                throw new Narrator.InitializeException("Failed to load library flite", e);
            }
        }

        private static native int flite_init();

        private static native float flite_text_to_speech(String var0, Pointer var1, String var2);

        private static class CmuUsKal16 {
            private static final String NATIVE_LIBRARY_NAME = "flite_cmu_us_kal16";

            private CmuUsKal16() {
            }

            public static void loadNative() throws Narrator.InitializeException {
                try {
                    Native.register(CmuUsKal16.class, (NativeLibrary)NativeLibrary.getInstance((String)NATIVE_LIBRARY_NAME));
                }
                catch (Throwable e) {
                    throw new Narrator.InitializeException("Failed to load library flite_cmu_us_kal16", e);
                }
            }

            private static native Pointer register_cmu_us_kal16(String var0);
        }
    }
}

